const path = require('path');
const webpack = require('webpack');
const HtmlWebPackPlugin = require('html-webpack-plugin');
const ForkTsCheckerWebpackPlugin = require('fork-ts-checker-webpack-plugin');
const babelOptions = {
    'presets': [
        '@babel/preset-react'
    ],
    'plugins': [
        ['import', {
            'libraryName': 'antd',
            'libraryDirectory': 'es',
            'style': 'css'
        }]
    ]
};
module.exports = {
    mode: 'development',
    entry: {test: './src/index.tsx'},
    output: {
        filename: '[name].js',
        path: path.resolve(__dirname, 'dist'),
        libraryTarget: 'umd',
        umdNamedDefine: true
        // publicPath: '/'
    },

    module: {
        rules: [
            {
                test: /\.tsx?$/,
                exclude: /node_modules/,
                use: [
                    {loader: 'cache-loader'},
                    {
                        loader: 'thread-loader',
                        options: {
                            workers: require('os').cpus().length - 1,
                        },
                    },
                    {
                        loader: 'babel-loader',
                        options: babelOptions
                    },
                    {
                        loader: 'ts-loader',
                        options: {happyPackMode: true}
                    }
                ]
            },
            {
                test: /\.jsx$/,
                loader: 'babel-loader',
                exclude: /node_modules/,
                options: babelOptions
            },
            {
                test: /\.css$/,
                use: [
                    'style-loader',
                    'css-loader'
                ]
            },
            {
                test: /\.scss$/,
                use: [
                    {
                        loader: 'style-loader'
                    },
                    {
                        loader: 'css-loader',
                        options: {
                            importLoaders: 1,
                            localsConvention: 'camelCase',
                            modules: {
                                mode: 'local',
                                localIdentName: '[name]__[local]--[hash:base64:5]',
                                context: path.resolve(__dirname, 'src'),
                            }
                        }
                    },
                    {
                        loader: 'sass-loader'
                    }
                ]
            },
            {
                test: /\.(png|jpg|gif)$/,
                use: [
                    {
                        loader: 'url-loader',
                        options: {
                            name: 'assets/img/[hash:16].[ext]',
                            limit: 1
                        }
                    }
                ]
            },
            {enforce: 'pre', test: /\.js$/, loader: 'source-map-loader'}
        ]
    },
    resolve: {
        extensions: [
            '.ts', '.tsx', '.js', '.jsx', '.json', '.css', '.scss'
        ]
    },
    // 调试服务
    devServer: {
        contentBase: path.join(__dirname, './'),
        compress: true,
        port: 7798,
        useLocalIp: true,
        host: '0.0.0.0',
        overlay: true,
        inline: true,
        hot: true,
        historyApiFallback: {
            index: '/index.html',
            rewrites: [
                {from: /^\/assets\/res.json/, to: '/test/assets/res.json'},
            ]
        },
        proxy: {
            '/test-assets': {
                target: 'http://nas.reality3d.cn:30002',
                changeOrigin: true
            }
        }
    },
    // 插件
    plugins: [
        new ForkTsCheckerWebpackPlugin({checkSyntacticErrors: true}),
        new webpack.HotModuleReplacementPlugin(),
        new HtmlWebPackPlugin({
            template: './public/index.html',
            filename: './index.html'
        })
    ]
};
